//+------------------------------------------------------------------+
//|                                  rsx + ma + tma asymmetric bands |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1  DeepSkyBlue
#property indicator_color2  Red
#property indicator_color3  Red
#property indicator_color4  Gold
#property indicator_color5  DimGray
#property indicator_color6  Red
#property indicator_color7  LimeGreen
#property indicator_style5  STYLE_DOT
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2

extern int    RsxPeriod       = 14;
extern int    RsxPrice        = 0;
extern int    SignalPeriod    = 5;
extern int    SignalMethod    = MODE_SMA;
extern int    TmaHalfLength   = 12;
extern int    TmaApplyTo      = 0; // 0 -> to RSX, 1 -> to MA of RSX
extern double BandsDeviations = 2.8;

double rsx[];
double rsxDa[];
double rsxDb[];
double signal[];
double tmBuffer[];
double upBuffer[];
double dnBuffer[];
double trend[];
double wrkBuffer[][15];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   IndicatorBuffers(8);
   SetIndexBuffer(0,rsx);//Blue
   SetIndexDrawBegin(0,TmaHalfLength+1);
   SetIndexLabel(0,"RSX");
   SetIndexBuffer(1,rsxDa);//Red
   SetIndexDrawBegin(1,TmaHalfLength+1);
   SetIndexLabel(1,"RSX");
   SetIndexBuffer(2,rsxDb);
   SetIndexDrawBegin(2,TmaHalfLength+1);
   SetIndexLabel(2,"RSX");
   SetIndexBuffer(3,signal);//Yellow
   SetIndexDrawBegin(3,TmaHalfLength+1);
   SetIndexLabel(3,"RSX signal");
   SetIndexBuffer(4,tmBuffer);//Magenta
   SetIndexDrawBegin(4,TmaHalfLength+1);
   SetIndexBuffer(5,upBuffer);// UP
   SetIndexDrawBegin(5,TmaHalfLength+1);
   SetIndexBuffer(6,dnBuffer);// Down
   SetIndexDrawBegin(6,TmaHalfLength+1);
   SetIndexBuffer(7,trend);

      TmaHalfLength = MathMax(TmaHalfLength,1);

   IndicatorShortName("Rsx ("+RsxPeriod+")");
   return(0);
}
int deinit() { return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

#define wuBuffer 13
#define wdBuffer 14

int start()
{
   
    
   double FullLength = 2.0*TmaHalfLength+1.0;
   int counted_bars=IndicatorCounted();
   int i,j,k,r,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-1,Bars-counted_bars+TmaHalfLength);
            if (ArrayRange(wrkBuffer,0) != Bars) ArrayResize(wrkBuffer,Bars);

   double Kg = (3.0)/(2.0+RsxPeriod);
   double Hg = 1.0-Kg;
   
   for(i=limit, r=Bars-i-1; i>=0; i--, r++)
   {
      wrkBuffer[r][12] = iMA(NULL,0,1,0,MODE_SMA,RsxPrice,i);

         if (i==(Bars-1)) { for (int c=0; c<12; c++) wrkBuffer[r][c] = 0; continue; }  

      double roc = wrkBuffer[r][12]-wrkBuffer[r-1][12];
      double roa = MathAbs(roc);
      for (k=0; k<3; k++)
      {
         int kk = k*2;
            wrkBuffer[r][kk+0] = Kg*roc                + Hg*wrkBuffer[r-1][kk+0];
            wrkBuffer[r][kk+1] = Kg*wrkBuffer[r][kk+0] + Hg*wrkBuffer[r-1][kk+1]; roc = 1.5*wrkBuffer[r][kk+0] - 0.5 * wrkBuffer[r][kk+1];
            wrkBuffer[r][kk+6] = Kg*roa                + Hg*wrkBuffer[r-1][kk+6];
            wrkBuffer[r][kk+7] = Kg*wrkBuffer[r][kk+6] + Hg*wrkBuffer[r-1][kk+7]; roa = 1.5*wrkBuffer[r][kk+6] - 0.5 * wrkBuffer[r][kk+7];
      }
      if (roa != 0)
           rsx[i] = MathMax(MathMin((roc/roa+1.0)*50.0,100.00),0.00); 
      else rsx[i] = 50.0;
   }
   
   for (i=limit; i>=0; i--) signal[i] = iMAOnArray(rsx,0,SignalPeriod,0,SignalMethod,i);


   if (trend[limit] == -1) ClearPoint(limit,rsxDa,rsxDb);
   for(i=limit, r=Bars-i-1; i>=0; i--, r++)
   {
      rsxDa[i] = EMPTY_VALUE;
      rsxDb[i] = EMPTY_VALUE;
      trend[i] = trend[i+1];
      if (rsx[i]>signal[i]) trend[i] =  1;
      if (rsx[i]<signal[i]) trend[i] = -1;
      if (trend[i] == -1) PlotPoint(i,rsxDa,rsxDb,rsx);
      if (TmaApplyTo==0)
         double price = rsx[i];
      else      price = signal[i];
      
         double sum  = (TmaHalfLength+1)*price;
         double sumw = (TmaHalfLength+1);
         for(j=1, k=TmaHalfLength; j<=TmaHalfLength; j++, k--)
         {
            if (TmaApplyTo==0)               
                  sum  += k*rsx[i+j];
            else  sum  += k*signal[i+j];
            sumw += k;

            if (j<=i)
            {
               if (TmaApplyTo==0)               
                     sum  += k*rsx[i-j];
               else  sum  += k*signal[i-j];
               sumw += k;
            }
         }
         tmBuffer[i] = sum/sumw;
            
         double diff = price-tmBuffer[i];
            if (i> (Bars-TmaHalfLength-2)) continue;
            if (i==(Bars-TmaHalfLength-2))
            {
               upBuffer[i] = tmBuffer[i];
               dnBuffer[i] = tmBuffer[i];
               if (diff>=0)
                  {
                     wrkBuffer[r][wuBuffer] = MathPow(diff,2);
                     wrkBuffer[r][wdBuffer] = 0;
                  }
               else
                  {               
                     wrkBuffer[r][wdBuffer] = MathPow(diff,2);
                     wrkBuffer[r][wuBuffer] = 0;
                  }                  
               continue;
            }

         wrkBuffer[r][wuBuffer] = wrkBuffer[r-1][wuBuffer];
         wrkBuffer[r][wdBuffer] = wrkBuffer[r-1][wdBuffer];
            if(diff>0)
            {
               wrkBuffer[r][wuBuffer] = (wrkBuffer[r-1][wuBuffer]*(FullLength-1)+MathPow(diff,2))/FullLength;
               wrkBuffer[r][wdBuffer] =  wrkBuffer[r-1][wdBuffer]*(FullLength-1)/FullLength;
            }
            if(diff<0)
            {
               wrkBuffer[r][wdBuffer] = (wrkBuffer[r-1][wdBuffer]*(FullLength-1)+MathPow(diff,2))/FullLength;
               wrkBuffer[r][wuBuffer] =  wrkBuffer[r-1][wuBuffer]*(FullLength-1)/FullLength;
            }
         upBuffer[i] = tmBuffer[i] + BandsDeviations*MathSqrt(wrkBuffer[r][wuBuffer]);
         dnBuffer[i] = tmBuffer[i] - BandsDeviations*MathSqrt(wrkBuffer[r][wdBuffer]);
   }
   
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

void ClearPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}


void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (first[i+1] == EMPTY_VALUE)
      {
      if (first[i+2] == EMPTY_VALUE) {
          first[i]    = from[i];
          first[i+1]  = from[i+1];
          second[i]   = EMPTY_VALUE;
         }
      else {
          second[i]   = from[i];
          second[i+1] = from[i+1];
          first[i]    = EMPTY_VALUE;
         }
      }
   else
      {
         first[i]   = from[i];
         second[i]  = EMPTY_VALUE;
      }
}